local MakePlayerCharacter = require "prefabs/player_common"


local assets = { Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/devon.zip" ),
		Asset( "ANIM", "anim/birdy.zip"), }

local prefabs = {"birdy"}


local start_inv =
{
    "birdy", 
}
 
local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wallace"

	 local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "devon.tex" )

	-- todo: Add an example special power here.
	
	inst.components.health:SetMaxHealth(50)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(50)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.5)
	inst.components.combat.min_attack_period = 0.25
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.4)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.5)
	inst.components.sanity.night_drain_mult = 2
	
   end

-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.devon = "The Hunter"
STRINGS.CHARACTER_NAMES.devon = "Devon"
STRINGS.CHARACTER_DESCRIPTIONS.devon = "*Survivalist: needs little food; quick but weak. \n*Brushed death once, now he sees it everywhere. \n*Has best friend, Birdy"
STRINGS.CHARACTER_QUOTES.devon = "\"Where'd ya get off to now, Birdy?\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.DEVON = require "speech_devon"


return MakePlayerCharacter("devon", prefabs, assets, fn, start_inv)
